function main(self)
	self:AnimationStep()

    if self.State == 0 then
		self:SetImage("CUSTOM_ICESHIELD")
		self:SetAnimation("CUSTOM_CYCLE72")
		self.BumpFlags.EnemyBullet = true
		self.AttackFlags.Enemy = true
		self.HitFlags.Player = true
		self.HitFlags.ThrownObject = true
		self.HitFlags.PistolBullet = true
		self.HitFlags.EnvBullet = true
		self.HitFlags.MagicBullet = true
		self.PhysicsType = PhysicsTypes.Fly
		self.AttackRect, self.MoveRect, self.HitRect = {-12,-12,12,12}, {-12,-12,12,12}, {-12,-12,12,12}
		self.Flags.AlwaysActive = true
		self.countBounces = 0
		self.timeLimit = GetTime() + 25000 -- lifetime of 25s
		self.shallExplode = false
		self.lastAttempt = Attempt()
		self.State = 1
	end

	if self.State == 1 then
		self.Flags.OnElevator = false
		-- move vertical and bounce from floor and ceiling:
		local pF = PhysicsFlags
		local moveVertical = self:Physics(self.X, self.Y + self.SpeedY)
		if AND(moveVertical, OR(pF.CeilingHit, pF.FloorHit, pF.GroundLand, pF.ElevatorLand)) ~= 0 then
			self.SpeedY = -self.SpeedY
		end
		-- move horizontal and bounce from walls:
		local moveHorizontal = self:Physics(self.X + self.SpeedX, self.Y)
		if AND(moveHorizontal, pF.WallHit) ~= 0 then
			self.SpeedX = -self.SpeedX
		end
		-- lifetime of 25 seconds or 5 bounces:
		if GetTime() > self.timeLimit then
			self.shallExplode = true
		end
		if self.arcanis and self.arcanis.State == 210 then -- Arcanis STATE.RESET
			self:Destroy()
		end
		if self.arcanis and self.arcanis.State == 211 then -- Arcanis STATE.DEFEATED
			self.State = 2 -- stops the projectile
		end
	end

	if self.State > 0 then
		if self.shallExplode then
			CreateObject {x=self.X, y=self.Y, z=6000, name="IceBallExplosion"}
			PlaySound("CLAW_ICESWORD")
			self:Destroy()
		end
		if Attempt() > self.lastAttempt then
			self:Destroy()
		end
	end

end

function hit(self)
	self.shallExplode = true
end

